/*********************************************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	main.c
*  :	
*  :	
*  :	
*  :	AD ο ʹڲ1.2v ѹУ׼õǰADĵѹֵ
*  ע:    
			
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************************************/
#include "stdlib.h"
#include "main.h"

float adc_value = 0;	//ADCתֵ

/**
  * @brief  get adc sample transfer value.
  * @retval data: transfer value.
  */
float adc_get_value(void)
{	
	uint temp_n = 0;
	uint temp12 = 0;
	uchar temp_channel = 0;
	float temp;
	temp_channel = ADCCL & 0xF0;
	while (ADTRG);
	temp_n = ADCRH & 0x0F;
	temp_n = temp_n << 8;
	temp_n += ADCRL;
	
	ADCHS3 = 1;
	ADCHS2 = 1;
	ADCHS1 = 0;
	ADCHS0 = 0;
	
	ADTRG = 1;
	while (ADTRG);

	temp12 = ADCRH & 0x0F;
	temp12 = temp12 << 8;
	temp12 += ADCRL;

	ADCHS3 = 0;
	ADCHS2 = 0;
	ADCCL |= temp_channel;

	temp = (float)temp_n /temp12;
	temp = temp * (1.2);
	
	return temp;
}
/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
 {	
	 RAMClear();
	 
	 // MCUʼ
	 MCUInit();			          
	// ʼADC
	ADCCL = 0xD4;//1/4VDD
	ADCCH = 0xD7;
	
	// ADCת
	ADEN = 1;
	//Delay100ms(1);
	ADTRG = 1;
	while(1)
    {
		clr_wdt();

		// ADCתֵ
		adc_value = adc_get_value();//1/4VDD ѹֵ
		
		// ADCת
		ADTRG = 1;
    }
}

/***********************************************************
:	void MCUInit(void) 
  :	ϵͳʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void MCUInit(void) 
{
    OSCWP = 0x55;
	HRCEN = 1;
	//LRCEN = 0;
	while(!HRCON){} //ȴHRC״̬λ
	SCKS  = 0;		//ϵͳʱлѡλ
	//OSCC1 = 0x00; //HRCʱԴ16M  1:1Ƶ
	while(CHG){}
	OSCWP = 0x5A;
}

/*********************************************************
:	void Delay100ms(uint time)
  :	ʱӳ
ֵ: timeʱλ100ms
ֵ: 
ֵ:  
**********************************************************/
void Delay100ms(uchar time)
{
   uchar i, j, k;
	for (i=0; i<time; i++)
	{
		for (j=0; j<100; j++)			
		{
			for (k=0; k<249; k++)
			{
				nop();
				nop();
				clr_wdt();    // 忴Ź
			}
		}
	}
}


/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
    GIE = 0;
    for(IAAH=0; IAAH<0x04; IAAH++)
    {
		for(IAAL=0; IAAL<0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		clr_wdt();
    }
}




